<?php
/*--------------------------------------------------------------
   TimespanDropdown.php 2021-07-06
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Overview\Factory\Option\Predefined;

use Gambio\Admin\Modules\Statistics\App\Overview\Factory;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\Collections\DropdownItems;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\Collections\OptionTitles;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Option\Dropdown;

class TimespanDropdown
{
    public const ID = "timespan";
    
    private const DEFAULT_VALUE = "week";
    
    private const LANGUAGE_CODE_GERMAN = "de";
    
    private const LANGUAGE_CODE_ENGLISH = "en";
    
    private const TITLES = [
        self::LANGUAGE_CODE_GERMAN  => "Zeitraum",
        self::LANGUAGE_CODE_ENGLISH => "Time Span",
    ];
    
    private const ITEMS = [
        "week"  => [
            self::LANGUAGE_CODE_GERMAN  => "Diese Woche",
            self::LANGUAGE_CODE_ENGLISH => "This week",
        ],
        "month" => [
            self::LANGUAGE_CODE_GERMAN  => "Dieser Monat",
            self::LANGUAGE_CODE_ENGLISH => "This month",
        ],
        "year"  => [
            self::LANGUAGE_CODE_GERMAN  => "Dieses Jahr",
            self::LANGUAGE_CODE_ENGLISH => "This year",
        ],
        "all"   => [
            self::LANGUAGE_CODE_GERMAN  => "Gesamt",
            self::LANGUAGE_CODE_ENGLISH => "Entire period",
        ],
    ];
    
    private const ITEM_TODAY = [
        'today' => [
            self::LANGUAGE_CODE_GERMAN  => "Heute",
            self::LANGUAGE_CODE_ENGLISH => "Today",
        ],
    ];
    
    
    /**
     * Return dropdown including today.
     */
    public static function createIncludingToday(Factory $factory): Dropdown
    {
        return $factory->useOptions()->useDropdowns()->createDropdown($factory->useOptions()->createId(self::ID),
                                                                      self::DEFAULT_VALUE,
                                                                      self::createItems($factory,
                                                                                        array_merge(self::ITEM_TODAY,
                                                                                                    self::ITEMS)),
                                                                      self::createTitles($factory));
    }
    
    
    /**
     * Return dropdown.
     */
    public static function create(Factory $factory): Dropdown
    {
        return $factory->useOptions()->useDropdowns()->createDropdown($factory->useOptions()->createId(self::ID),
                                                                      self::DEFAULT_VALUE,
                                                                      self::createItems($factory, self::ITEMS),
                                                                      self::createTitles($factory));
    }
    
    
    /**
     * Return titles.
     */
    private static function createTitles(Factory $factory): OptionTitles
    {
        return $factory->useOptions()
            ->createTitles(...array_map(function (string $languageCode, string $title) use ($factory) {
                return $factory->useOptions()->createTitle($factory->createLanguageCode($languageCode), $title);
            },
                array_keys(self::TITLES),
                self::TITLES));
    }
    
    
    /**
     * Return items.
     */
    private static function createItems(Factory $factory, array $items): DropdownItems
    {
        return $factory->useOptions()
            ->useDropdowns()
            ->createItems(...array_map(function (string $value, array $titles) use ($factory) {
                return $factory->useOptions()->useDropdowns()->createItem($factory->useOptions()
                                                                              ->useDropdowns()
                                                                              ->createValue($value),
                                                                          $factory->useOptions()
                                                                              ->useDropdowns()
                                                                              ->createItemTitles(...
                                                                                  array_map(function (
                                                                                      string $languageCode,
                                                                                      string $title
                                                                                  ) use ($factory) {
                                                                                      return $factory->useOptions()
                                                                                          ->useDropdowns()
                                                                                          ->createItemTitle($factory->createLanguageCode($languageCode),
                                                                                                            $title);
                                                                                  },
                                                                                      array_keys($titles),
                                                                                      $titles)));
            },
                array_keys($items),
                $items));
    }
}